/****** Object:  StoredProcedure [dbo].[P_GERA_FECOP_EST_NF_SAI]    Script Date: 10/07/2012 18:09:10 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_FECOP_EST_NF_SAI]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_FECOP_EST_NF_SAI]
GO
GO  

--EXEC P_GERA_FECOP_EST_NF_SAI 1,1, '01/08/2016','01/08/2016',0,0
CREATE PROCEDURE [dbo].[P_GERA_FECOP_EST_NF_SAI] (@CD_EMP INT, 
													   @CD_FILIAL INT, 
													   @DT_INI DATETIME,
													   @DT_FIM DATETIME,
													   @VISUALIZAR INT = 0)  WITH ENCRYPTION AS 
													   

CREATE TABLE #RsSaidas (CD_EMP                   INT,
							CD_FILIAL            INT,
							CD_NF                INT,
							CD_IT                INT,
							CD_PROD              INT,
							FECOP_RECALCULADO	 INT,
							PERC_ALIQ_FECOP		 MONEY)
					


--Gerando tabela inicial com o calculo padrao de PIS/COFINS
INSERT INTO #RsSaidas
SELECT
	EST_NF_SAI.CD_EMP,
	EST_NF_SAI.CD_FILIAL,
	EST_NF_SAI.CD_NF,
	EST_NF_SAI_IT.CD_IT,
	EST_NF_SAI_IT.CD_PROD,
	1 AS FECOP_RECALCULADO,
	VINC_NCM.PERC_ALIQ AS PERC_ALIQ_FECOP

 FROM     EST_NF_SAI
          INNER JOIN EST_NF_SAI_IT
          ON       EST_NF_SAI.Cd_Emp    = EST_NF_SAI_IT.Cd_Emp
          AND      EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL
          AND      EST_NF_SAI.CD_NF     = EST_NF_SAI_IT.CD_NF
		  INNER JOIN EST_TRIB ON 
		         EST_NF_SAI_IT.CD_TRIB = EST_TRIB.CD_TRIB
		  INNER JOIN EST_PROD ON 
          EST_NF_SAI_IT.Cd_Emp  = EST_PROD.Cd_Emp
          AND      EST_NF_SAI_IT.CD_PROD = EST_PROD.CD_PROD
          INNER JOIN GLB_MOV_OP
          ON       EST_NF_SAI.Cd_Nt_Mov = GLB_MOV_OP.Cd_Mov_Op
          INNER JOIN PRC_FILIAL
          ON       EST_NF_SAI.Cd_Emp    = PRC_FILIAL.Cd_Emp
          AND      EST_NF_SAI.CD_FILIAL = PRC_FILIAL.CD_FILIAL
          INNER JOIN EST_PROD_NCM_CADASTRO_COMB_POBREZA VINC_NCM
          ON       VINC_NCM.NR_NCM = EST_PROD.NR_NCM
          LEFT JOIN GLB_CID
          ON  PRC_FILIAL.CD_CID = GLB_CID.CD_CID 
		  OUTER apply UFD_GLB_PESSOA (EST_NF_SAI.CD_CLI , GLB_MOV_OP.DEST_ORIG)V_GLB_PESSOA

WHERE

	EST_NF_SAI.CD_EMP = @CD_EMP 
	AND EST_NF_SAI.CD_FILIAL = @CD_FILIAL 
	AND EST_NF_SAI.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
	AND GLB_CID.UF COLLATE SQL_Latin1_General_CP1_CI_AS = VINC_NCM.UF COLLATE SQL_Latin1_General_CP1_CI_AS
	AND GLB_MOV_OP.TP_MOV  in (0,3)  --  compra/venda e bonificao
	AND V_GLB_PESSOA.CONTRIBUINTE IN (0,9)
	AND RIGHT(EST_TRIB.CD_TRIB_FC,2) in (00,20)
	AND ISNULL(PROD_EXCESSAO_FECOP,0) = 0

--Alterando a entrada de acordo com o novo calculo criado
IF @VISUALIZAR =0 
begin
	UPDATE
		s
	SET 
 		s.PERC_FECOP=snv.PERC_ALIQ_FECOP,
        s.FECOP_RECALCULADO= snv.FECOP_RECALCULADO
		
	FROM
		#RsSaidas snv INNER JOIN EST_NF_SAI_IT s ON
		snv.CD_EMP = s.CD_EMP AND
		snv.CD_FILIAL = s.CD_FILIAL AND 
		snv.CD_NF = s.CD_NF AND
		snv.CD_PROD = s.CD_PROD AND
		snv.CD_IT = s.CD_IT 
end

IF @VISUALIZAR =1 
begin
--Alterando a saida de acordo com o novo calculo criado
SELECT
*
FROM
	#RsSaidas 
end
DROP TABLE #RsSaidas;
